/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import org.python.constantine.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    EPERM(1),
    ENOENT(2),
    ESRCH(3),
    EINTR(4),
    EIO(5),
    ENXIO(6),
    E2BIG(7),
    ENOEXEC(8),
    EBADF(9),
    ECHILD(10),
    EDEADLK(11),
    ENOMEM(12),
    EACCES(13),
    EFAULT(14),
    ENOTBLK(15),
    EBUSY(16),
    EEXIST(17),
    EXDEV(18),
    ENODEV(19),
    ENOTDIR(20),
    EISDIR(21),
    EINVAL(22),
    ENFILE(23),
    EMFILE(24),
    ENOTTY(25),
    ETXTBSY(26),
    EFBIG(27),
    ENOSPC(28),
    ESPIPE(29),
    EROFS(30),
    EMLINK(31),
    EPIPE(32),
    EDOM(33),
    ERANGE(34),
    EWOULDBLOCK(35),
    EAGAIN(35),
    EINPROGRESS(36),
    EALREADY(37),
    ENOTSOCK(38),
    EDESTADDRREQ(39),
    EMSGSIZE(40),
    EPROTOTYPE(41),
    ENOPROTOOPT(42),
    EPROTONOSUPPORT(43),
    ESOCKTNOSUPPORT(44),
    EOPNOTSUPP(102),
    EPFNOSUPPORT(46),
    EAFNOSUPPORT(47),
    EADDRINUSE(48),
    EADDRNOTAVAIL(49),
    ENETDOWN(50),
    ENETUNREACH(51),
    ENETRESET(52),
    ECONNABORTED(53),
    ECONNRESET(54),
    ENOBUFS(55),
    EISCONN(56),
    ENOTCONN(57),
    ESHUTDOWN(58),
    ETOOMANYREFS(59),
    ETIMEDOUT(60),
    ECONNREFUSED(61),
    ELOOP(62),
    ENAMETOOLONG(63),
    EHOSTDOWN(64),
    EHOSTUNREACH(65),
    ENOTEMPTY(66),
    EUSERS(68),
    EDQUOT(69),
    ESTALE(70),
    EREMOTE(71),
    ENOLCK(77),
    ENOSYS(78),
    EOVERFLOW(84),
    EIDRM(90),
    ENOMSG(91),
    EILSEQ(92),
    EBADMSG(94),
    EMULTIHOP(95),
    ENODATA(96),
    ENOLINK(97),
    ENOSR(98),
    ENOSTR(99),
    EPROTO(100),
    ETIME(101);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 102L;

    private Errno(int n2) {
        this.value = n2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    @Override
    public final int value() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> enumMap = new EnumMap<Errno, String>(Errno.class);
            enumMap.put(EPERM, "Operation not permitted");
            enumMap.put(ENOENT, "No such file or directory");
            enumMap.put(ESRCH, "No such process");
            enumMap.put(EINTR, "Interrupted system call");
            enumMap.put(EIO, "Input/output error");
            enumMap.put(ENXIO, "Device not configured");
            enumMap.put(E2BIG, "Argument list too long");
            enumMap.put(ENOEXEC, "Exec format error");
            enumMap.put(EBADF, "Bad file descriptor");
            enumMap.put(ECHILD, "No child processes");
            enumMap.put(EDEADLK, "Resource deadlock avoided");
            enumMap.put(ENOMEM, "Cannot allocate memory");
            enumMap.put(EACCES, "Permission denied");
            enumMap.put(EFAULT, "Bad address");
            enumMap.put(ENOTBLK, "Block device required");
            enumMap.put(EBUSY, "Resource busy");
            enumMap.put(EEXIST, "File exists");
            enumMap.put(EXDEV, "Cross-device link");
            enumMap.put(ENODEV, "Operation not supported by device");
            enumMap.put(ENOTDIR, "Not a directory");
            enumMap.put(EISDIR, "Is a directory");
            enumMap.put(EINVAL, "Invalid argument");
            enumMap.put(ENFILE, "Too many open files in system");
            enumMap.put(EMFILE, "Too many open files");
            enumMap.put(ENOTTY, "Inappropriate ioctl for device");
            enumMap.put(ETXTBSY, "Text file busy");
            enumMap.put(EFBIG, "File too large");
            enumMap.put(ENOSPC, "No space left on device");
            enumMap.put(ESPIPE, "Illegal seek");
            enumMap.put(EROFS, "Read-only file system");
            enumMap.put(EMLINK, "Too many links");
            enumMap.put(EPIPE, "Broken pipe");
            enumMap.put(EDOM, "Numerical argument out of domain");
            enumMap.put(ERANGE, "Result too large");
            enumMap.put(EWOULDBLOCK, "Resource temporarily unavailable");
            enumMap.put(EAGAIN, "Resource temporarily unavailable");
            enumMap.put(EINPROGRESS, "Operation now in progress");
            enumMap.put(EALREADY, "Operation already in progress");
            enumMap.put(ENOTSOCK, "Socket operation on non-socket");
            enumMap.put(EDESTADDRREQ, "Destination address required");
            enumMap.put(EMSGSIZE, "Message too long");
            enumMap.put(EPROTOTYPE, "Protocol wrong type for socket");
            enumMap.put(ENOPROTOOPT, "Protocol not available");
            enumMap.put(EPROTONOSUPPORT, "Protocol not supported");
            enumMap.put(ESOCKTNOSUPPORT, "Socket type not supported");
            enumMap.put(EOPNOTSUPP, "Operation not supported on socket");
            enumMap.put(EPFNOSUPPORT, "Protocol family not supported");
            enumMap.put(EAFNOSUPPORT, "Address family not supported by protocol family");
            enumMap.put(EADDRINUSE, "Address already in use");
            enumMap.put(EADDRNOTAVAIL, "Can't assign requested address");
            enumMap.put(ENETDOWN, "Network is down");
            enumMap.put(ENETUNREACH, "Network is unreachable");
            enumMap.put(ENETRESET, "Network dropped connection on reset");
            enumMap.put(ECONNABORTED, "Software caused connection abort");
            enumMap.put(ECONNRESET, "Connection reset by peer");
            enumMap.put(ENOBUFS, "No buffer space available");
            enumMap.put(EISCONN, "Socket is already connected");
            enumMap.put(ENOTCONN, "Socket is not connected");
            enumMap.put(ESHUTDOWN, "Can't send after socket shutdown");
            enumMap.put(ETOOMANYREFS, "Too many references: can't splice");
            enumMap.put(ETIMEDOUT, "Operation timed out");
            enumMap.put(ECONNREFUSED, "Connection refused");
            enumMap.put(ELOOP, "Too many levels of symbolic links");
            enumMap.put(ENAMETOOLONG, "File name too long");
            enumMap.put(EHOSTDOWN, "Host is down");
            enumMap.put(EHOSTUNREACH, "No route to host");
            enumMap.put(ENOTEMPTY, "Directory not empty");
            enumMap.put(EUSERS, "Too many users");
            enumMap.put(EDQUOT, "Disc quota exceeded");
            enumMap.put(ESTALE, "Stale NFS file handle");
            enumMap.put(EREMOTE, "Too many levels of remote in path");
            enumMap.put(ENOLCK, "No locks available");
            enumMap.put(ENOSYS, "Function not implemented");
            enumMap.put(EOVERFLOW, "Value too large to be stored in data type");
            enumMap.put(EIDRM, "Identifier removed");
            enumMap.put(ENOMSG, "No message of desired type");
            enumMap.put(EILSEQ, "Illegal byte sequence");
            enumMap.put(EBADMSG, "Bad message");
            enumMap.put(EMULTIHOP, "EMULTIHOP (Reserved)");
            enumMap.put(ENODATA, "No message available on STREAM");
            enumMap.put(ENOLINK, "ENOLINK (Reserved)");
            enumMap.put(ENOSR, "No STREAM resources");
            enumMap.put(ENOSTR, "Not a STREAM");
            enumMap.put(EPROTO, "Protocol error");
            enumMap.put(ETIME, "STREAM ioctl timeout");
            return enumMap;
        }
    }
}

